//
//  YHFamilyInfoModel.swift
//  galaxy
//
//  Created by edy on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHFamilyNamePinYin: SmartCodable {
    
    var family_name: String = ""
    var given_name: String = ""
    
    required init() {
        
    }
}

class YHFamilyGroupModel: SmartCodable {
    var orderid: Int = 0
    var main: YHApplicantInfoModel = YHApplicantInfoModel()
    var spouse: YHApplicantInfoModel = YHApplicantInfoModel()
    var children: [YHApplicantInfoModel] = []

    enum CodingKeys: String, CodingKey {
        case orderid = "order_id"
        case main = "main"
        case spouse = "spouse"
        case children = "children"
    }
    
    required init() {
        
    }

    init(orderid: Int, main: YHApplicantInfoModel, spouse: YHApplicantInfoModel, children: [YHApplicantInfoModel]) {
        self.orderid = orderid
        self.main = main
        self.spouse = spouse
        self.children = children
    }
}

// MARK: - Main
class YHApplicantInfoModel: SmartCodable {
    
    var info: YHFamilyMemberInfoModel = YHFamilyMemberInfoModel()
    var confirmStatus: Int = 0

    enum CodingKeys: String, CodingKey {
        case info = "info"
        case confirmStatus = "confirm_status"
    }
    
    required init() {
        
    }

    init(info: YHFamilyMemberInfoModel, confirmStatus: Int) {
        self.info = info
        self.confirmStatus = confirmStatus
    }
}

// MARK: - Info
class YHFamilyMemberInfoModel: SmartCodable {
    var id: Int = -1
    var name: String = ""
    var nameHistory: String = ""
    var familyName: String = ""
    var familyNameHistory: String = ""
    var givenName: String = ""
    var givenNameHistory: String = ""
    var married: String = ""
    var marriedHistory: String = ""
    var birthPlaceAboard: String = "0"
    var birthPlaceAboardHistory: String = ""
    var birthPlace: YHApplicantBirthPlaceModel = YHApplicantBirthPlaceModel()
    var birthPlaceHistory: YHApplicantBirthPlaceModel = YHApplicantBirthPlaceModel()
    var nationalityType: Int = -1
    var nationalityTypeHistory: Int = -1
    var nationality: String = ""
    var nationalityHistory: String = ""
    var hkIdentityid: String = ""
    var hkIdentityidHistory: String = ""
    var identity: YHApplicantIdentityModel?
    var occupationName: String = ""
    var occupationNameHistory: String = ""
    
    // 自定义属性
    var relation:Int = YHFamilyMemberRelationType.none.rawValue
    // 是否检测编辑字段
    var isCheck: Bool = false
    
    func getRelation() -> String {
        
        if relation == YHFamilyMemberRelationType.mainApplicant.rawValue {
            return "主申人"
            
        } else if relation == YHFamilyMemberRelationType.spouse.rawValue {
            return "配偶"
            
        } else if relation == YHFamilyMemberRelationType.child.rawValue {
            return "子女"
        }
        return ""
    }
    
    func getMarriageState() -> String {
        return self.getMarriageStatus(self.married)
    }
    
    func getHistoryMarriageState() -> String {
        return self.getMarriageStatus(self.marriedHistory)
    }
    
    func getBirthNation() -> String {
    
        if self.birthPlaceAboard == "0" {
            return "国内"
            
        } else if self.birthPlaceAboard == "1" {
            return "国外"
        }
        return ""
    }
    
    func getHistoryBirthNation() -> String {
        if self.birthPlaceAboardHistory == "0" {
            return "国内"
            
        } else if self.birthPlaceAboardHistory == "1" {
            return "国外"
        }
        return ""
    }
    
    private func getMarriageStatus(_ marrage: String) -> String {
        let arr = YHSheetPickerView.dataSource[.marriage1]!
        for item in arr {
            if item.index == Int(marrage) {
                return item.title
            }
        }
        return ""
    }
    
    required init() {
        
    }

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case name = "name"
        case nameHistory = "name_history"
        case familyName = "family_name"
        case familyNameHistory = "family_name_history"
        case givenName = "given_name"
        case givenNameHistory = "given_name_history"
        case married = "married"
        case marriedHistory = "married_history"
        case birthPlaceAboard = "birth_place_aboard"
        case birthPlaceAboardHistory = "birth_place_aboard_history"
        case birthPlace = "birth_place"
        case birthPlaceHistory = "birth_place_history"
        case nationalityType = "nationality_type"
        case nationalityTypeHistory = "nationality_type_history"
        case nationality = "nationality"
        case nationalityHistory = "nationality_history"
        case hkIdentityid = "hk_identity_id"
        case hkIdentityidHistory = "hk_identity_id_history"
        case identity = "identity"
        case occupationName = "occupation_name"
        case occupationNameHistory = "occupation_name_history"
    }

    init(id: Int, name: String, nameHistory: String, familyName: String, familyNameHistory: String, givenName: String, givenNameHistory: String, married: String, marriedHistory: String, birthPlaceAboard: String, birthPlaceAboardHistory: String, birthPlace: YHApplicantBirthPlaceModel, birthPlaceHistory: YHApplicantBirthPlaceModel, nationalityType: Int, nationalityTypeHistory: Int, nationality: String, nationalityHistory: String, hkIdentityid: String, hkIdentityidHistory: String, identity: YHApplicantIdentityModel, occupationName: String, occupationNameHistory: String) {
        
        self.id = id
        self.name = name
        self.nameHistory = nameHistory
        self.familyName = familyName
        self.familyNameHistory = familyNameHistory
        self.givenName = givenName
        self.givenNameHistory = givenNameHistory
        self.married = married
        self.marriedHistory = marriedHistory
        self.birthPlaceAboard = birthPlaceAboard
        self.birthPlaceAboardHistory = birthPlaceAboardHistory
        self.birthPlace = birthPlace
        self.birthPlaceHistory = birthPlaceHistory
        self.nationalityType = nationalityType
        self.nationalityTypeHistory = nationalityTypeHistory
        self.nationality = nationality
        self.nationalityHistory = nationalityHistory
        self.hkIdentityid = hkIdentityid
        self.hkIdentityidHistory = hkIdentityidHistory
        self.identity = identity
        self.occupationName = occupationName
        self.occupationNameHistory = occupationNameHistory
    }
}

// MARK: - BirthPlace
class YHApplicantBirthPlaceModel: SmartCodable {
    
    var area: [String] = []
    var country: String = ""
    var details: String = ""
    var foreign: String = ""
    
    required init() {
        
    }

    enum CodingKeys: String, CodingKey {
        case area = "area"
        case country = "country"
        case details = "details"
        case foreign = "foreign"
    }

    init(area: [String], country: String, details: String, foreign: String) {
        self.area = area
        self.country = country
        self.details = details
        self.foreign = foreign
    }
}

// MARK: - Identity
class YHApplicantIdentityModel: SmartCodable {
    
    var type: Int = -1
    var name: String = ""
    var number: String = ""
    
    required init() {
        
    }

    enum CodingKeys: String, CodingKey {
        case type = "type"
        case name = "name"
        case number = "number"
    }

    init(type: Int, name: String, number: String) {
        self.type = type
        self.name = name
        self.number = number
    }
}

